#pragma once

namespace RTCam
{

class FpsTimer
{
public:
	FpsTimer(void);
	~FpsTimer(void);

	void Update(float delta);
	void Reset();
	
	float GetAvgFps();

	// Delta time values are in seconds
	float GetMinDelta();
	float GetAvgDelta();
	float GetMaxDelta();
	
	float GetMinDeltaSinceReset();
	float GetMaxDeltaSinceReset();

private:
	static const int kNumSamples = 64;
	
	bool m_isReset;
	float m_lowestDelta;
	float m_highestDelta;
	float m_deltaSamples[kNumSamples];
	int m_currentSample;
};

} // end namespace